/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;
import tictim.paraglider.wind.WindWriter;

public class WindUpdater {
    private static final int XZ_RAD_HALF = 4;
    private static final int GROUND_Y_MIN = -2;
    private static final int GROUND_Y_MAX = 4;
    private static final int PARAGLIDING_Y_MIN = -11;
    private static final int PARAGLIDING_Y_MAX = 1;
    private final BlockPos.Mutable mpos = new BlockPos.Mutable();
    private final Set<WindChunk> modifiedChunks = new HashSet<WindChunk>();

    public Set<WindChunk> getModifiedChunks() {
        return this.modifiedChunks;
    }

    public void placeAround(PlayerEntity player) {
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        int y = MathHelper.func_76128_c((double)player.func_226278_cu_());
        int z = MathHelper.func_76128_c((double)player.func_226281_cx_());
        this.place(player.field_70170_p, x - 4, y + (player.func_233570_aj_() ? -2 : -11), z - 4, x + 4, y + (player.func_233570_aj_() ? 4 : 1), z + 4);
    }

    public void place(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            ParagliderMod.LOGGER.warn("Cannot place wind because there's no Wind capability associated with world {}", (Object)world);
            return;
        }
        WindWriter writer = new WindWriter(wind, world.func_82737_E());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                writer.setXZ(x, z);
                boolean hasFireY = false;
                int fireY = 0;
                int y = minY;
                while (true) {
                    block10: {
                        boolean isWindSource;
                        block9: {
                            this.mpos.func_181079_c(x, y, z);
                            BlockState state = world.func_180495_p((BlockPos)this.mpos);
                            isWindSource = ModCfg.isWindSource(state);
                            if (!hasFireY) break block9;
                            int height = y - fireY;
                            if (height < 10 && !isWindSource && !state.func_185904_a().func_76230_c() && !Block.func_220055_a((IWorldReader)world, (BlockPos)this.mpos, (Direction)Direction.DOWN) && !Block.func_220055_a((IWorldReader)world, (BlockPos)this.mpos, (Direction)Direction.UP)) break block10;
                            if (height > 2) {
                                writer.wind(fireY, height);
                            }
                            hasFireY = false;
                        }
                        if (y > maxY) break;
                        if (isWindSource) {
                            fireY = y;
                            hasFireY = true;
                        }
                    }
                    ++y;
                }
                writer.end();
            }
        }
        this.modifiedChunks.addAll(writer.getModifiedChunks());
    }

    public void checkPlacedWind(World world) {
        Wind wind = Wind.of((ICapabilityProvider)world);
        if (wind == null) {
            return;
        }
        for (WindChunk windChunk : wind.getWindChunks()) {
            Collection<WindNode> allRootNodes = windChunk.getAllRootNodes();
            for (WindNode node : allRootNodes.toArray(new WindNode[0])) {
                WindNode updated = this.validate(windChunk, node, world);
                if (updated == node) continue;
                if (updated == null) {
                    windChunk.removeAllNodesInXZ(node.x, node.z);
                    continue;
                }
                windChunk.putNode(updated);
            }
        }
    }

    @Nullable
    private WindNode validate(WindChunk windChunk, WindNode node, World world) {
        long gameTime = world.func_82737_E();
        if (node.updatedTime != gameTime) {
            if (node.isExpired(gameTime) || !ModCfg.isWindSource(world.func_180495_p((BlockPos)this.mpos.func_181079_c(node.x, node.y, node.z)))) {
                this.modifiedChunks.add(windChunk);
                return node.next != null ? this.validate(windChunk, node.next, world) : null;
            }
            node.updatedTime = gameTime;
        }
        if (node.next != null) {
            node.next = this.validate(windChunk, node.next, world);
        }
        return node;
    }
}

